﻿using Sunny.UI;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Newtonsoft.Json;
using System.IO;
using System.Diagnostics;
using ZSMusic.BLLEX;
using Win32Helper;
using Helper;
using System.Threading;
//System.Runtime.InteropServices.COMException
namespace ZSMusic.Winform
{
    public partial class FrmEx : UIForm
    {
        public static Dictionary<string, string> Solutions
        {
            get
            {
                //System.ArgumentNullException
                //System.IndexOutOfRangeException;
                //System.ArgumentOutOfRangeException;
                Dictionary<string, string> dic = new Dictionary<string, string>();
                dic.Add("System.Runtime.InteropServices.COMException", "未知错误,若不影响软件正常使用忽略即可\r\n若频繁出现,请发送错误报告或与开发者联系");
                dic.Add("System.NotImplementedException", "该功能尚未实现,请等待软件更新");
                dic.Add("ZSMusic.Model.Exceptions.MusicNotFoundException", "您查询的为下架或付费音乐无法解析,或软件所用的api已失效,或网络异常\r\n请期待软件更新与完善");
                dic.Add("System.NullReferenceException", "你未选中任何歌曲或未能解析出歌曲信息\r\n也可能是未知错误,请发送错误报告");
                dic.Add("System.ArgumentNullException", "您的操作提供的参数为空");
                dic.Add("System.ArgumentException", "您的操作提供的参数为空");
                dic.Add("System.IndexOutOfRangeException", "试图访问索引超出数组界限的数组元素时引发的异常\r\n请发送错误报告");
                dic.Add("System.Exception", "请检查网络连接\r\n若网络正常则为未知错误,请发送错误报告");
                dic.Add("Newtonsoft.Json.JsonReaderException", "未搜索到结果");
                dic.Add("System.ArgumentOutOfRangeException", "当参数值超出调用的方法所定义的允许取值范围时引发的异常\r\n请发送错误报告");
                dic.Add("System.NotSupportedException", "该功能尚未实现,请等待软件更新");
                dic.Add("ZSMusic.Model.NotAllowedException", "软件作者不允许此操作");
                dic.Add("System.Net.WebException", "请检查网络连接\r\n若网络正常则为api失效");
                dic.Add("System.UnauthorizedAccessException", "请以管理员身份运行");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");
                //dic.Add("", "");


                return dic;
            }
        }
        public Exception Ex { get; set; }
        public FrmEx()
        {
            InitializeComponent();
            
        }

        public FrmEx( Exception ex)
        {
            Ex = ex;
            InitializeComponent();
        }

        private void FrmEx_Load(object sender, EventArgs e)
        {
            propertyGrid.SelectedObject = Ex;
            string json = JsonConvert.SerializeObject(Ex);
            txtMessage.Text =Ex.GetType()+"\r\n"+ Ex.Message;
            txtDetail.Text = json;
            if (Ex.GetType().ToString() != "System.NotImplementedException")
            {
                File.WriteAllText(string.Format("{0}\\errorlog\\{1} {2}.txt", Application.StartupPath, DateTime.Now.ToString("yyyy-MM-dd hh.mm.ss"),Ex.GetType().ToString() ), json);
            }
            var solution = from d in Solutions
                           where d.Key == Ex.GetType().ToString()
                           select d.Value;
            txtSolution.Text = solution.FirstOrDefault();

            System.Media.SystemSounds.Hand.Play();
            if (Ex.GetType().ToString() == "System.NotImplementedException")
            {
                btnSend.Enabled = false;
                btnOpen.Enabled = false;
            }
        }

        private void btnOpen_Click(object sender, EventArgs e)
        {
            Process.Start("explorer.exe", Application.StartupPath + "\\errorlog\\");
        }

        private void btnOk_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnSend_Click(object sender, EventArgs e)
        {
            if (!HttpHelper.IsConnectedToInternet)
            {
                this.ShowErrorTip("请检查网络连接");
                return;
            }
            this.ShowInfoTip("正在发送,您可以关闭本窗口等待后台发送完毕");
            ThreadPool.QueueUserWorkItem(delegate
            {
                SendError();
            }, null);
        }

        private void SendError()
        {
            btnSend.Enabled = false;
            this.Cursor = Cursors.AppStarting;
            if (MusicHelper.SendReport(Ex))
            {
                this.ShowSuccessTip("发送成功");
                btnSend.Enabled = false;
            }
            else
            {
                this.ShowErrorTip("发送失败");
                btnSend.Enabled = true;
            }
            this.Cursor = Cursors.Default;
        }
    }
}
